<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Admin extends CI_Controller {
	public function index(){
		$this->load->library('session');

		if($this->session->userdata('rol') === '0' || $this->session->userdata('rol') === '3'){
			$username = $this->session->userdata('Nombre');
			$this->load->view('admin-header',array('username'=>$username));
			$this->load->view('index_admin');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	public function crear_pdf(){
		$this->load->model('grupo');
		$this->load->helper("usuario");
		$this->load->helper('file');
		$this->load->helper('download');
		$this->load->helper('dompdf');
		if($this->session->userdata('rol') === '0' or $this->session->userdata('rol') === '3'){

			$id_grupo = $this->input->post("grupo");
			$usr_rol=$this->session->userdata('rol');

			$grupo = $this->db->select("Usuario.idUsuario, Usuario.nombres, Usuario.apellidos, Usuario.usuario, Usuario.contrasena,Usuario.edad, Usuario.sexo, Estudiante.noLista")
			->join('Usuario', 'Estudiante.Usuario_idUsuario = Usuario.idUsuario')
			->get_where('Estudiante', array('Estudiante.Grupo_idGrupo' => intval($id_grupo)));
			$content_type = 'content-4';
			$username = $this->session->userdata('Nombre');

			$grupo_i = $this->grupo->obtener_informacion( $id_grupo );

			$view = $this->input->post("vista");
			$filename = 'file.pdf';
			$filename = str_replace(' ', '_', $filename);

			// $this->load->helper(array('dompdf', 'file'));
			// page info here, db calls, etc.
			// $html = $this->load->view('controller/viewfile', $data, true);
			$html = $this->load->view($view,array(
											'grupo' => $grupo->result(),
											'id_grupo'=>$id_grupo,
											'grupo_info' => $grupo_i,
											'usr_rol' => $usr_rol),true);
			pdf_create($html, $filename);
			// or
			//$data = pdf_create($html,$filename, false);
			//force_download($filename, $data);
			//if you want to write it to disk and/or send it as an attachment
		}else{
			redirect(base_url());
		}
	}
	public function seleccionar_nivel(){
		if($this->session->userdata('rol') === '0'  or $this->session->userdata('rol') === '3'){
			$username = $this->session->userdata('Nombre');
			$this->load->view('admin-header',array('username'=>$username));
			$this->load->view('nivel_select');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	public function seleccionar_grupo_secundaria(){
		if($this->session->userdata('rol') === '0' or $this->session->userdata('rol') === '3' ){
			$this->load->database();
			$escuelas = $this->db->query("SELECT DISTINCT `Escuela`.`nombre` ,  `Escuela`.`idEscuela` FROM `Escuela` JOIN  `Grupo` ON  `Escuela`.`idEscuela` =  `Grupo`.`Escuela_idEscuela` WHERE  `Grupo`.`nivel` = 0");
			$username = $this->session->userdata('Nombre');
			$this->load->view('admin-header',array('username'=>$username));
			$this->load->view("grupos_select", array(
				"escuelas"=>$escuelas->result()
			));
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	public function seleccionar_grupo_medio_superior(){
		if($this->session->userdata('rol') === '0' or $this->session->userdata('rol') === '3'){
			$this->load->database();
			$escuelas = $this->db->query("SELECT DISTINCT `Escuela`.`nombre` ,  `Escuela`.`idEscuela` FROM `Escuela` JOIN  `Grupo` ON  `Escuela`.`idEscuela` =  `Grupo`.`Escuela_idEscuela` WHERE  `Grupo`.`nivel` = 1");
			$username = $this->session->userdata('Nombre');
			$this->load->view('admin-header',array('username'=>$username));
			$this->load->view("grupos_select_medio", array(
				"escuelas"=>$escuelas->result()
			));
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	public function grupos(){
		if($this->session->userdata('rol') === '0'){
			$this->load->library('form_validation');
			$this->load->database();
			$escuelas = $this->db->get("Escuela");
			$username = $this->session->userdata('Nombre');
			$this->load->view('admin-header',array('username'=>$username));
			$this->load->view("nuevo_grupo", array(
				"escuelas"=>$escuelas->result()
			));
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	public function grupos_secundaria(){
		if($this->session->userdata('rol') === '0' or $this->session->userdata('rol') === '3'){
			$this->load->library('form_validation');
			$idEscuela = $this->uri->segment(3);
			$this->load->database();
			$escuelas = $this->db->select("nombre, idGrupo")->from("Grupo")->where("nivel", 0)->where("Escuela_idEscuela", $idEscuela)->get();
			$username = $this->session->userdata('Nombre');
			$this->load->view('admin-header',array('username'=>$username));
			$this->load->view("grupos_escuela", array(
				"grupos"=>$escuelas->result()
			));
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	public function grupos_superior(){
		if($this->session->userdata('rol') === '0' or $this->session->userdata('rol') === '3'){
			$this->load->library('form_validation');
			$idEscuela = $this->uri->segment(3);
			$this->load->database();
			$escuelas = $this->db->select("nombre, idGrupo")->from("Grupo")->where("nivel", 1)->where("Escuela_idEscuela", $idEscuela)->get();
			$username = $this->session->userdata('Nombre');
			$this->load->view('admin-header',array('username'=>$username));
			$this->load->view("grupos_escuela", array(
				"grupos"=>$escuelas->result()
			));
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	public function agregar_grupo(){
		if($this->session->userdata('rol') === '0'){
			$this->load->library('form_validation');
			$this->load->helper('usuario');

			$this->form_validation->set_rules('escuela', 'Escuela', 'required');
			$this->form_validation->set_rules('nombre', 'Nombre', 'required');
			$this->form_validation->set_rules('turno', 'Turno', 'required');
			$this->form_validation->set_rules('nivel', 'Nivel', 'required');

			$config['upload_path'] = './grupos/';
			$config['allowed_types'] = '*';
			$config['max_size']	= '100';

			$this->load->library('upload', $config);

			if ($this->form_validation->run() != FALSE){
				if ($this->upload->do_upload("alumnos")){
					$data = $this->upload->data();

					$escuela = $this->input->post("escuela");
					$grupo = $this->input->post("nombre");
					$turno = $this->input->post("turno");
					$nivel = $this->input->post("nivel");

					$escuela_query = $this->db->get_where('Escuela', array('idEscuela'=>$escuela), 1);

					$escuela = $escuela_query->result();

					$this->db->insert("Grupo", array(
						"Escuela_idEscuela" => $escuela[0]->idEscuela,
						"nombre" => $grupo,
						"nivel" => $nivel
					));

					$id_group = $this->db->insert_id();

					$handle = fopen($data['full_path'], "r");

					while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
						$nombre = ( isset( $data[1] ) ) ? $data[1] : "" ;
						$apellidos = ( isset( $data[2] ) ) ? $data[2] : "" ;
						$numero = ( isset( $data[0] ) ) ? $data[0] : "" ;

						//Sustituir por la forma de hacer las contraseñas
						$pass = randomString(7);

						$usuario =  usuario($escuela[0]->nombre,$grupo,$numero);

						//Se crea el usuario
						$this->db->insert('Usuario', array(
							'nombres' => $nombre.' '.$apellidos,
							'apellidos' => '',
							'contrasena' => $pass,
							'usuario' => $usuario,
							'rol' => 1
						));

						$id_usuario = $this->db->insert_id();

						//Se crea el estudiante

						$this->db->insert('Estudiante', array(
							'Usuario_idUsuario' => $id_usuario,
							'Grupo_idGrupo' => $id_group,
							'noLista' => $numero,
							'turno' => $turno,
							'grado' => $nivel
						));
					}
					redirect(base_url().'index.php/admin/grupo/'.$id_group);
				}else{

				}
			}else{
				$this->load->database();
				$escuelas = $this->db->get("Escuela");
				$username = $this->session->userdata('Nombre');
				$this->load->view('admin-header',array('username'=>$username));
				$this->load->view("nuevo_grupo", array(
					"escuelas"=>$escuelas->result()
				));
				$this->load->view('footer');
			}
		}else{
			redirect(base_url());
		}
	}
	function agregar_escuela(){
		if($this->session->userdata('rol') === '0'){
			$this->load->library('form_validation');
			$this->load->helper('usuario');

			$this->form_validation->set_rules('escuela', 'Escuela', 'required');

			if ($this->form_validation->run() != FALSE){
				$this->db->insert('Escuela', array(
					'nombre' => $this->input->post('escuela')
				));
				$this->session->set_flashdata('message', 'Escuela añadida correctamente.');
				redirect(base_url().'index.php/admin/admin/');
			}else{
				$username = $this->session->userdata('Nombre');
				$this->load->view('admin-header',array('username'=>$username));
				$this->load->view("nueva_escuela");
				$this->load->view('footer');
			}

		}else{
			redirect(base_url());
		}

	}
	function grupo(){
		$this->load->model('grupo');
		if($this->session->userdata('rol') === '0' or $this->session->userdata('rol') === '3'){
			$id_grupo = $this->uri->segment(3);
			$usr_rol=$this->session->userdata('rol');
			$active="pass";

			$grupo = $this->db->select("Usuario.idUsuario, Usuario.nombres, Usuario.apellidos, Usuario.usuario, Usuario.contrasena,Usuario.edad, Usuario.sexo, Estudiante.noLista, Estudiante.idEstudiante")
			->join('Usuario', 'Estudiante.Usuario_idUsuario = Usuario.idUsuario')
			->get_where('Estudiante', array('Estudiante.Grupo_idGrupo' => intval($id_grupo)));
			$content_type = 'content-4';
			$username = $this->session->userdata('Nombre');

			$grupo_i = $this->grupo->obtener_informacion( $id_grupo );

			$this->load->view('admin-header', array(
												'content_type' => $content_type,
												'username'=>$username,
												'grupo' => $grupo->result(),
												'id_grupo'=>$id_grupo,
												'grupo_info' => $grupo_i,
												'usr_rol' => $usr_rol,
												'imprimible' => true));
			$this->load->view('grupo_general_todos', array('active'=>$active,'id_grupo'=>$id_grupo));
			$this->load->view("grupo", array(
											'grupo' => $grupo->result(),
											'id_grupo'=>$id_grupo,
											'grupo_info' => $grupo_i,
											'usr_rol' => $usr_rol));
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}

	function grupo_escalas(){
		$this->load->model('grupo');
		if($this->session->userdata('rol') === '0' or $this->session->userdata('rol') === '3'){
			$id_estudiante = $this->session->userdata('id_estudiante');

			$id_grupo = $this->uri->segment(3);

			$grupo = $this->db->select("Usuario.nombres, Usuario.apellidos, Usuario.usuario, Usuario.contrasena, Estudiante.noLista, Estudiante.idEstudiante, Usuario.idUsuario")
			->join('Usuario', 'Estudiante.Usuario_idUsuario = Usuario.idUsuario')
			->get_where('Estudiante', array('Estudiante.Grupo_idGrupo' => intval($id_grupo)));

			$grupoinfo = $this->grupo->obtener_informacion( $id_grupo );

			$estudiantes = array();
			$escala = "TODAS";

			foreach ($grupo->result() as $x => $estudiante) {

				$puntaje = array();
				$respuestas = array();


				////////////////////// SNAP /////////////////////////////////////////
				$respuestas3 = $this->db->select('Escala.pregunta, Escala.puntos')
					->from('Escala')
					->where('Estudiante_idEstudiante', intval($estudiante->idEstudiante))
					->where('Trastorno_idEscala', 8)
					->where('puntos', '3')
					->count_all_results();

				$respuestas2 = $this->db->select('Escala.pregunta, Escala.puntos')
					->from('Escala')
					->where('Estudiante_idEstudiante', intval($estudiante->idEstudiante))
					->where('Trastorno_idEscala', 8)
					->where('puntos', '2')
					->count_all_results();

				$sumatoria = $this->db->select_sum('puntos')
					->from('Escala')
					->where('Estudiante_idEstudiante', intval($estudiante->idEstudiante))
					->where('Trastorno_idEscala', 8)
					->get();

				$sumatoria = $sumatoria->result();

				if( !is_null($sumatoria[0]->puntos) ){
					$puntos_snap = $respuestas3 + $respuestas2;
					if(( $respuestas3 + $respuestas2 ) <= 5){
						array_push($respuestas, array("SNAP" => "R/B"));
						//array_push($estudiantes, array($estudiante, "Riesgo bajo"));
						array_push($puntaje, array("SNAP" => $puntos_snap));
					}else if(( $respuestas3 + $respuestas2 ) > 5){
						//array_push($estudiantes, array($estudiante, "Alto riesgo"));
						array_push($respuestas, array("SNAP" => "R/A"));
						array_push($puntaje, array("SNAP" => $puntos_snap));
					}else{
						array_push($respuestas, array("SNAP" => "wht"));
						array_push($puntaje, array("SNAP" => $puntos_snap));
					}
				}else{
					array_push($respuestas, array("SNAP" => "S/C"));
					//array_push($estudiantes, array($estudiante, "S/C"));
					array_push($puntaje, array("SNAP" => ""));
				}

				//////////////////////////// BECK1 /////////////////////////////////////////

				$sumatoria = $this->db->select_sum('puntos')
					->from('Escala')
					->where('Estudiante_idEstudiante', intval($estudiante->idEstudiante))
					->where('Trastorno_idEscala', 7)
					->get();

				$sumatoria = $sumatoria->result();

				if( !is_null($sumatoria[0]->puntos) ){
					$puntos = $sumatoria[0]->puntos;
					if(0 <= $puntos && $puntos <= 5){
						//array_push($estudiantes, array($estudiante, "Riesgo bajo"));
						array_push($respuestas, array("BECK" => "R/B"));
						array_push($puntaje, array("BECK" => $puntos));
					}elseif(6 <= $puntos && $puntos <= 15){
						//array_push($estudiantes, array($estudiante, "Riesgo medio"));
						array_push($respuestas, array("BECK" => "R/M"));
						array_push($puntaje, array("BECK" => $puntos));
					}elseif(16 <= $puntos && $puntos <= 30){
						//array_push($estudiantes, array($estudiante, "Alto riesgo"));
						array_push($respuestas, array("BECK" => "R/A"));
						array_push($puntaje, array("BECK" => $puntos));
					}elseif(31 <= $puntos && $puntos <= 66){
						//array_push($estudiantes, array($estudiante, "Alto riesgo"));
						array_push($respuestas, array("BECK" => "R/A"));
						array_push($puntaje, array("BECK" => $puntos));
					}
					elseif($puntos > 66){
						//array_push($estudiantes, array($estudiante, "Alto riesgo"));
						array_push($respuestas, array("BECK" => "R/A"));
						array_push($puntaje, array("BECK" => $puntos));
					}
				}else{
					//array_push($estudiantes, array($estudiante, "S/C"));
					array_push($respuestas, array("BECK" => "S/C"));
					array_push($puntaje, array("BECK" => ""));
				}


				//////////////////////////////// BECK2 //////////////////////////
				$sumatoria = $this->db->select_sum('puntos')
					->from('Escala')
					->where('Estudiante_idEstudiante', intval($estudiante->idEstudiante))
					->where('Trastorno_idEscala', 9)
					->get();

				$sumatoria = $sumatoria->result();

				if( !is_null($sumatoria[0]->puntos) ){
					$puntos = $sumatoria[0]->puntos;
					if(0 <= $puntos && $puntos <= 9){
						//array_push($estudiantes, array($estudiante, "Depresión Mínima"));
						array_push($respuestas, array("BECK2" => "R/B"));
						array_push($puntaje, array("BECK2" => $puntos));
					}elseif(10 <= $puntos && $puntos <= 16){
						//array_push($estudiantes, array($estudiante, "Depresión Leve"));
						array_push($respuestas, array("BECK2" => "R/M"));
						array_push($puntaje, array("BECK2" => $puntos));
					}elseif(17 <= $puntos && $puntos <= 29){
						//array_push($estudiantes, array($estudiante, "Depresión Moderada"));
						array_push($respuestas, array("BECK2" => "R/A"));
						array_push($puntaje, array("BECK2" => $puntos));
					}elseif(30 <= $puntos && $puntos <= 63){
						//array_push($estudiantes, array($estudiante, "Depresión Severa"));
						array_push($respuestas, array("BECK2" => "R/A"));
						array_push($puntaje, array("BECK2" => $puntos));
					}
					elseif($puntos > 63){
						//array_push($estudiantes, array($estudiante, "Depresión Severa"));
						array_push($respuestas, array("BECK2" => "R/A"));
						array_push($puntaje, array("BECK2" => $puntos));
					}
				}else{
					//array_push($estudiantes, array($estudiante, "S/C"));
					array_push($respuestas, array("BECK2" => "S/C"));
					array_push($puntaje, array("BECK2" => ""));
				}

				array_push($estudiantes, array($estudiante, $respuestas, $puntaje));
			}


			$usr_rol=$this->session->userdata('rol');
			$active = 'gral';
			$content_type = 'content-3';
			$username = $this->session->userdata('Nombre');
			$this->load->view('admin-header', array(
												'content_type' => $content_type,
												'username'=>$username,'id_grupo'=>$id_grupo,
												'escala' => $escala,
												'grupo_info' => $grupoinfo,
												'imprimible' => true
												));
			$this->load->view('grupo_general_todos',array('active'=>$active, 'id_grupo'=>$id_grupo ));
			$this->load->view("grupo_escalas", array(
													'grupo' => $estudiantes,
													'id_grupo'=>$id_grupo,
													'escala' => $escala,
													'grupo_info' => $grupoinfo,
													'usr_rol' => $usr_rol));
			//$this->load->view("grupo", array('grupo' => $estudiantes, 'id_grupo'=>$id_grupo, 'escala' => $escala));
			$this->load->view('footer');
		}

	}
	function grupo_escalas_xml(){
		$this->load->model('grupo');
		if($this->session->userdata('rol') === '0' or $this->session->userdata('rol') === '3'){
			$id_estudiante = $this->session->userdata('id_estudiante');

			$id_grupo = $this->uri->segment(3);

			$grupo = $this->db->select("Usuario.nombres, Usuario.apellidos, Usuario.usuario, Usuario.contrasena, Estudiante.noLista, Estudiante.idEstudiante, Usuario.idUsuario")
			->join('Usuario', 'Estudiante.Usuario_idUsuario = Usuario.idUsuario')
			->get_where('Estudiante', array('Estudiante.Grupo_idGrupo' => intval($id_grupo)));

			$grupoinfo = $this->grupo->obtener_informacion( $id_grupo );

			$estudiantes = array();
			$escala = "TODAS";

			foreach ($grupo->result() as $x => $estudiante) {

				$puntaje = array();
				$respuestas = array();


				////////////////////// SNAP /////////////////////////////////////////
				$respuestas3 = $this->db->select('Escala.pregunta, Escala.puntos')
					->from('Escala')
					->where('Estudiante_idEstudiante', intval($estudiante->idEstudiante))
					->where('Trastorno_idEscala', 8)
					->where('puntos', '3')
					->count_all_results();

				$respuestas2 = $this->db->select('Escala.pregunta, Escala.puntos')
					->from('Escala')
					->where('Estudiante_idEstudiante', intval($estudiante->idEstudiante))
					->where('Trastorno_idEscala', 8)
					->where('puntos', '2')
					->count_all_results();

				$sumatoria = $this->db->select_sum('puntos')
					->from('Escala')
					->where('Estudiante_idEstudiante', intval($estudiante->idEstudiante))
					->where('Trastorno_idEscala', 8)
					->get();

				$sumatoria = $sumatoria->result();

				if( !is_null($sumatoria[0]->puntos) ){
					$puntos_snap = $respuestas3 + $respuestas2;
					if(( $respuestas3 + $respuestas2 ) <= 5){
						array_push($respuestas, array("SNAP" => "R/B"));
						//array_push($estudiantes, array($estudiante, "Riesgo bajo"));
						array_push($puntaje, array("SNAP" => $puntos_snap));
					}else if(( $respuestas3 + $respuestas2 ) > 5){
						//array_push($estudiantes, array($estudiante, "Alto riesgo"));
						array_push($respuestas, array("SNAP" => "R/A"));
						array_push($puntaje, array("SNAP" => $puntos_snap));
					}else{
						array_push($respuestas, array("SNAP" => "wht"));
						array_push($puntaje, array("SNAP" => $puntos_snap));
					}
				}else{
					array_push($respuestas, array("SNAP" => "S/C"));
					//array_push($estudiantes, array($estudiante, "S/C"));
					array_push($puntaje, array("SNAP" => ""));
				}

				//////////////////////////// BECK1 /////////////////////////////////////////

				$sumatoria = $this->db->select_sum('puntos')
					->from('Escala')
					->where('Estudiante_idEstudiante', intval($estudiante->idEstudiante))
					->where('Trastorno_idEscala', 7)
					->get();

				$sumatoria = $sumatoria->result();

				if( !is_null($sumatoria[0]->puntos) ){
					$puntos = $sumatoria[0]->puntos;
					if(0 <= $puntos && $puntos <= 5){
						//array_push($estudiantes, array($estudiante, "Riesgo bajo"));
						array_push($respuestas, array("BECK" => "R/B"));
						array_push($puntaje, array("BECK" => $puntos));
					}elseif(6 <= $puntos && $puntos <= 15){
						//array_push($estudiantes, array($estudiante, "Riesgo medio"));
						array_push($respuestas, array("BECK" => "R/M"));
						array_push($puntaje, array("BECK" => $puntos));
					}elseif(16 <= $puntos && $puntos <= 30){
						//array_push($estudiantes, array($estudiante, "Alto riesgo"));
						array_push($respuestas, array("BECK" => "R/A"));
						array_push($puntaje, array("BECK" => $puntos));
					}elseif(31 <= $puntos && $puntos <= 66){
						//array_push($estudiantes, array($estudiante, "Alto riesgo"));
						array_push($respuestas, array("BECK" => "R/A"));
						array_push($puntaje, array("BECK" => $puntos));
					}
					elseif($puntos > 66){
						//array_push($estudiantes, array($estudiante, "Alto riesgo"));
						array_push($respuestas, array("BECK" => "R/A"));
						array_push($puntaje, array("BECK" => $puntos));
					}
				}else{
					//array_push($estudiantes, array($estudiante, "S/C"));
					array_push($respuestas, array("BECK" => "S/C"));
					array_push($puntaje, array("BECK" => ""));
				}


				//////////////////////////////// BECK2 //////////////////////////
				$sumatoria = $this->db->select_sum('puntos')
					->from('Escala')
					->where('Estudiante_idEstudiante', intval($estudiante->idEstudiante))
					->where('Trastorno_idEscala', 9)
					->get();

				$sumatoria = $sumatoria->result();

				if( !is_null($sumatoria[0]->puntos) ){
					$puntos = $sumatoria[0]->puntos;
					if(0 <= $puntos && $puntos <= 9){
						//array_push($estudiantes, array($estudiante, "Depresión Mínima"));
						array_push($respuestas, array("BECK2" => "D/Min"));
						array_push($puntaje, array("BECK2" => $puntos));
					}elseif(10 <= $puntos && $puntos <= 16){
						//array_push($estudiantes, array($estudiante, "Depresión Leve"));
						array_push($respuestas, array("BECK2" => "D/L"));
						array_push($puntaje, array("BECK2" => $puntos));
					}elseif(17 <= $puntos && $puntos <= 29){
						//array_push($estudiantes, array($estudiante, "Depresión Moderada"));
						array_push($respuestas, array("BECK2" => "D/Mod"));
						array_push($puntaje, array("BECK2" => $puntos));
					}elseif(30 <= $puntos && $puntos <= 63){
						//array_push($estudiantes, array($estudiante, "Depresión Severa"));
						array_push($respuestas, array("BECK2" => "D/S"));
						array_push($puntaje, array("BECK2" => $puntos));
					}
					elseif($puntos > 63){
						//array_push($estudiantes, array($estudiante, "Depresión Severa"));
						array_push($respuestas, array("BECK2" => "D/S"));
						array_push($puntaje, array("BECK2" => $puntos));
					}
				}else{
					//array_push($estudiantes, array($estudiante, "S/C"));
					array_push($respuestas, array("BECK2" => "S/C"));
					array_push($puntaje, array("BECK2" => ""));
				}

				array_push($estudiantes, array($estudiante, $respuestas, $puntaje));
			}

			$grupoinfo = $this->grupo->obtener_informacion( $id_grupo );

			$estudiantes_xml = array();

			$escuela_array = array("Escuela:", $grupoinfo->escuela);
			array_push($estudiantes_xml, $escuela_array);
			$grupo_array =  array("Grupo:", $grupoinfo->grupo);
			array_push($estudiantes_xml, $grupo_array);
			$arrayName = array("No lista", "Nombres", "TDAH", "puntaje", "Ansiedad", "puntaje", "Depresión","puntaje");

			array_push($estudiantes_xml, $arrayName);

			foreach ($estudiantes as $key_estudiante => $value_estudiante) {
				$estudiante_xml = array();
				array_push($estudiante_xml, $value_estudiante[0]->noLista);
				array_push($estudiante_xml, $value_estudiante[0]->nombres);
				foreach ($value_estudiante[1] as $key_respuesta => $value_respuesta) {
					foreach ($value_respuesta as $key => $value) {
						array_push($estudiante_xml, $value);
						foreach ($estudiantes[$key_estudiante][2][$key_respuesta] as $key_p => $value_p) {
							array_push($estudiante_xml, $value_p);
						}
					}
				}
				array_push($estudiantes_xml, $estudiante_xml);
			}

			$this->load->view("excel", array("result" => $estudiantes_xml));
		}
	}


	/////////////////////// EDI ///////////////////////////////////////////
	function grupo_EDI(){
		$this->load->model('grupo');
		if($this->session->userdata('rol') === '0' or $this->session->userdata('rol') === '3'){
			$escala = 'EDI';

			$id_grupo = $this->uri->segment(3);

			$grupo = $this->db->select("Usuario.nombres, Usuario.apellidos, Usuario.usuario, Usuario.contrasena, Usuario.idUsuario, Estudiante.noLista, Estudiante.idEstudiante")
				->join('Usuario', 'Estudiante.Usuario_idUsuario = Usuario.idUsuario')
				->get_where('Estudiante', array('Estudiante.Grupo_idGrupo' => intval($id_grupo)));

			$estudiantes = array();

			$impulso_delgadez = 10;
			$sintomatologia_bulimica = 11;
			$instisfaccion_corporal = 12;
			$inefectividad_baja_autoestima = 13;
			$perfeccionismo = 14;
			$desconfianza_interpersonal = 15;
			$conciencia_interoceptiva = 16;
			$miedo_madurar = 17;

			foreach ($grupo->result() as $x => $estudiante) {
				$impulso_delgadez_sum = $this->db->select_sum('puntos')
						->from('Escala')
						->where('Estudiante_idEstudiante', intval($estudiante->idEstudiante))
						->where('Trastorno_idEscala', $impulso_delgadez)
						->get();
				$sintomatologia_bulimica_sum = $this->db->select_sum('puntos')
						->from('Escala')
						->where('Estudiante_idEstudiante', intval($estudiante->idEstudiante))
						->where('Trastorno_idEscala', $sintomatologia_bulimica)
						->get();
				$instisfaccion_corporal_sum = $this->db->select_sum('puntos')
						->from('Escala')
						->where('Estudiante_idEstudiante', intval($estudiante->idEstudiante))
						->where('Trastorno_idEscala', $instisfaccion_corporal)
						->get();
				$inefectividad_baja_autoestima_sum = $this->db->select_sum('puntos')
						->from('Escala')
						->where('Estudiante_idEstudiante', intval($estudiante->idEstudiante))
						->where('Trastorno_idEscala', $inefectividad_baja_autoestima)
						->get();
				$perfeccionismo_sum = $this->db->select_sum('puntos')
						->from('Escala')
						->where('Estudiante_idEstudiante', intval($estudiante->idEstudiante))
						->where('Trastorno_idEscala', $perfeccionismo)
						->get();
				$desconfianza_interpersonal_sum = $this->db->select_sum('puntos')
						->from('Escala')
						->where('Estudiante_idEstudiante', intval($estudiante->idEstudiante))
						->where('Trastorno_idEscala', $desconfianza_interpersonal)
						->get();
				$conciencia_interoceptiva_sum = $this->db->select_sum('puntos')
						->from('Escala')
						->where('Estudiante_idEstudiante', intval($estudiante->idEstudiante))
						->where('Trastorno_idEscala', $conciencia_interoceptiva)
						->get();
				$miedo_madurar_sum = $this->db->select_sum('puntos')
						->from('Escala')
						->where('Estudiante_idEstudiante', intval($estudiante->idEstudiante))
						->where('Trastorno_idEscala', $miedo_madurar)
						->get();

				$impulso_delgadez_sum = $impulso_delgadez_sum->result();
				$sintomatologia_bulimica_sum = $sintomatologia_bulimica_sum->result();
				$instisfaccion_corporal_sum = $instisfaccion_corporal_sum->result();
				$inefectividad_baja_autoestima_sum = $inefectividad_baja_autoestima_sum->result();
				$perfeccionismo_sum = $perfeccionismo_sum->result();
				$desconfianza_interpersonal_sum = $desconfianza_interpersonal_sum->result();
				$conciencia_interoceptiva_sum = $conciencia_interoceptiva_sum->result();
				$miedo_madurar_sum = $miedo_madurar_sum->result();

				$resultados = array();
				$puntaje = array();

				//Impulso a la delgadez
				if( !is_null($impulso_delgadez_sum[0]->puntos) ){
					$puntos = $impulso_delgadez_sum[0]->puntos;
					if(0 <= $puntos && $puntos <= 4){
						//Bajo Riesgo
						array_push($resultados, array("B/R"));
						array_push($puntaje, array($puntos));
					}elseif(5 <= $puntos && $puntos <= 21){
						//Alto Riesgo
						array_push($resultados, array("A/R"));
						array_push($puntaje, array($puntos));
					}
				}else{
					array_push($resultados, array("S/C"));
					array_push($puntaje, array(" "));
				}
				//Sitomatología bulímica
				if( !is_null($sintomatologia_bulimica_sum[0]->puntos) ){
					$puntos = $sintomatologia_bulimica_sum[0]->puntos;
					if(0 <= $puntos && $puntos <= 1){
						array_push($resultados, array("B/R"));
						array_push($puntaje, array($puntos));
					}elseif(2 <= $puntos && $puntos <= 21){
						array_push($resultados, array("A/R"));
						array_push($puntaje, array($puntos));
					}
				}else{
					array_push($resultados, array("S/C"));
					array_push($puntaje, array(" "));
				}
				//Insatisfacción Corporal
				if( !is_null($instisfaccion_corporal_sum[0]->puntos) ){
					$puntos = $instisfaccion_corporal_sum[0]->puntos;
					if(0 <= $puntos && $puntos <= 1){
						array_push($resultados, array("B/R"));
						array_push($puntaje, array($puntos));
					}elseif(2 <= $puntos && $puntos <= 27){
						array_push($resultados, array("A/R"));
						array_push($puntaje, array($puntos));
					}
				}else{
					array_push($resultados, array("S/C"));
					array_push($puntaje, array(" "));
				}
				//inefectividad y baja autoestima
				if( !is_null($inefectividad_baja_autoestima_sum[0]->puntos) ){
					$puntos = $inefectividad_baja_autoestima_sum[0]->puntos;
					if(0 <= $puntos && $puntos <= 1){
						array_push($resultados, array("B/R"));
						array_push($puntaje, array($puntos));
					}elseif(2 <= $puntos && $puntos <= 30){
						array_push($resultados, array("A/R"));
						array_push($puntaje, array($puntos));
					}
				}else{
					array_push($resultados, array("S/C"));
					array_push($puntaje, array(" "));
				}
				//perfeccionismo
				if( !is_null($perfeccionismo_sum[0]->puntos) ){
					$puntos = $perfeccionismo_sum[0]->puntos;
					array_push($resultados, array("LISTO"));
					array_push($puntaje, array($puntos));
				}else{
					array_push($resultados, array("S/C"));
					array_push($puntaje, array(" "));
				}
				//desconfianza interpersonal
				if( !is_null($desconfianza_interpersonal_sum[0]->puntos) ){
					$puntos = $desconfianza_interpersonal_sum[0]->puntos;
					array_push($resultados, array("LISTO"));
					array_push($puntaje, array($puntos));
				}else{
					array_push($resultados, array("S/C"));
					array_push($puntaje, array(" "));
				}

				//Conciencia interoceptiva
				if( !is_null($conciencia_interoceptiva_sum[0]->puntos) ){
					$puntos = $conciencia_interoceptiva_sum[0]->puntos;
					if(0 <= $puntos && $puntos <= 1){
						array_push($resultados, array("B/R"));
						array_push($puntaje, array($puntos));
					}elseif(2 <= $puntos && $puntos <= 30){
						array_push($resultados, array("A/R"));
						array_push($puntaje, array($puntos));
					}
				}else{
					array_push($resultados, array("S/C"));
					array_push($puntaje, array(" "));
				}
				//Miedo a madurar
				if( !is_null($miedo_madurar_sum[0]->puntos) ){
					$puntos = $miedo_madurar_sum[0]->puntos;
					if(0 <= $puntos && $puntos <= 1){
						array_push($resultados, array("B/R"));
						array_push($puntaje, array($puntos));
					}elseif(2 <= $puntos && $puntos <= 24){
						array_push($resultados, array("A/R"));
						array_push($puntaje, array($puntos));
					}
				}else{
					array_push($resultados, array("S/C"));
					array_push($puntaje, array(" "));
				}

				array_push($estudiantes, array($estudiante, $resultados, $puntaje));
			}
		}else{
			redirect(base_url());
		}

		$grupo = $this->grupo->obtener_informacion( $id_grupo );

		$usr_rol=$this->session->userdata('rol');
		$active = 'edi';
		$content_type = 'content-4';
		$username = $this->session->userdata('Nombre');
		$this->load->view('admin-header', array(
												'content_type' => $content_type,
												'username'=>$username,'id_grupo'=>$id_grupo,
												'escala' => $escala,
												'grupo_info' => $grupo,
												'imprimible' => true
												));
		$this->load->view('grupo_general_todos',array('active'=>$active,'id_grupo'=>$id_grupo));
		$this->load->view("grupo_edi", array('grupo' => $estudiantes, 'escala' => $escala,'id_grupo'=>$id_grupo, 'grupo_info' => $grupo, 'usr_rol' => $usr_rol));
		$this->load->view('footer');
	}

	function grupo_EDI_xml(){
		$this->load->model('grupo');
		if($this->session->userdata('rol') === '0' or $this->session->userdata('rol') === '3'){
			$escala = 'EDI';

			$id_grupo = $this->uri->segment(3);

			$grupo = $this->db->select("Usuario.nombres, Usuario.apellidos, Usuario.usuario, Usuario.contrasena, Usuario.idUsuario, Estudiante.noLista, Estudiante.idEstudiante")
				->join('Usuario', 'Estudiante.Usuario_idUsuario = Usuario.idUsuario')
				->get_where('Estudiante', array('Estudiante.Grupo_idGrupo' => intval($id_grupo)));

			$estudiantes = array();

			$impulso_delgadez = 10;
			$sintomatologia_bulimica = 11;
			$instisfaccion_corporal = 12;
			$inefectividad_baja_autoestima = 13;
			$perfeccionismo = 14;
			$desconfianza_interpersonal = 15;
			$conciencia_interoceptiva = 16;
			$miedo_madurar = 17;

			foreach ($grupo->result() as $x => $estudiante) {
				$impulso_delgadez_sum = $this->db->select_sum('puntos')
						->from('Escala')
						->where('Estudiante_idEstudiante', intval($estudiante->idEstudiante))
						->where('Trastorno_idEscala', $impulso_delgadez)
						->get();
				$sintomatologia_bulimica_sum = $this->db->select_sum('puntos')
						->from('Escala')
						->where('Estudiante_idEstudiante', intval($estudiante->idEstudiante))
						->where('Trastorno_idEscala', $sintomatologia_bulimica)
						->get();
				$instisfaccion_corporal_sum = $this->db->select_sum('puntos')
						->from('Escala')
						->where('Estudiante_idEstudiante', intval($estudiante->idEstudiante))
						->where('Trastorno_idEscala', $instisfaccion_corporal)
						->get();
				$inefectividad_baja_autoestima_sum = $this->db->select_sum('puntos')
						->from('Escala')
						->where('Estudiante_idEstudiante', intval($estudiante->idEstudiante))
						->where('Trastorno_idEscala', $inefectividad_baja_autoestima)
						->get();
				$perfeccionismo_sum = $this->db->select_sum('puntos')
						->from('Escala')
						->where('Estudiante_idEstudiante', intval($estudiante->idEstudiante))
						->where('Trastorno_idEscala', $perfeccionismo)
						->get();
				$desconfianza_interpersonal_sum = $this->db->select_sum('puntos')
						->from('Escala')
						->where('Estudiante_idEstudiante', intval($estudiante->idEstudiante))
						->where('Trastorno_idEscala', $desconfianza_interpersonal)
						->get();
				$conciencia_interoceptiva_sum = $this->db->select_sum('puntos')
						->from('Escala')
						->where('Estudiante_idEstudiante', intval($estudiante->idEstudiante))
						->where('Trastorno_idEscala', $conciencia_interoceptiva)
						->get();
				$miedo_madurar_sum = $this->db->select_sum('puntos')
						->from('Escala')
						->where('Estudiante_idEstudiante', intval($estudiante->idEstudiante))
						->where('Trastorno_idEscala', $miedo_madurar)
						->get();

				$impulso_delgadez_sum = $impulso_delgadez_sum->result();
				$sintomatologia_bulimica_sum = $sintomatologia_bulimica_sum->result();
				$instisfaccion_corporal_sum = $instisfaccion_corporal_sum->result();
				$inefectividad_baja_autoestima_sum = $inefectividad_baja_autoestima_sum->result();
				$perfeccionismo_sum = $perfeccionismo_sum->result();
				$desconfianza_interpersonal_sum = $desconfianza_interpersonal_sum->result();
				$conciencia_interoceptiva_sum = $conciencia_interoceptiva_sum->result();
				$miedo_madurar_sum = $miedo_madurar_sum->result();

				$resultados = array();
				$puntaje = array();

				//Impulso a la delgadez
				if( !is_null($impulso_delgadez_sum[0]->puntos) ){
					$puntos = $impulso_delgadez_sum[0]->puntos;
					if(0 <= $puntos && $puntos <= 4){
						//Bajo Riesgo
						array_push($resultados, array("B/R"));
						array_push($puntaje, array($puntos));
					}elseif(5 <= $puntos && $puntos <= 21){
						//Alto Riesgo
						array_push($resultados, array("A/R"));
						array_push($puntaje, array($puntos));
					}
				}else{
					array_push($resultados, array("S/C"));
					array_push($puntaje, array(" "));
				}
				//Sitomatología bulímica
				if( !is_null($sintomatologia_bulimica_sum[0]->puntos) ){
					$puntos = $sintomatologia_bulimica_sum[0]->puntos;
					if(0 <= $puntos && $puntos <= 1){
						array_push($resultados, array("B/R"));
						array_push($puntaje, array($puntos));
					}elseif(2 <= $puntos && $puntos <= 21){
						array_push($resultados, array("A/R"));
						array_push($puntaje, array($puntos));
					}
				}else{
					array_push($resultados, array("S/C"));
					array_push($puntaje, array(" "));
				}
				//Insatisfacción Corporal
				if( !is_null($instisfaccion_corporal_sum[0]->puntos) ){
					$puntos = $instisfaccion_corporal_sum[0]->puntos;
					if(0 <= $puntos && $puntos <= 1){
						array_push($resultados, array("B/R"));
						array_push($puntaje, array($puntos));
					}elseif(2 <= $puntos && $puntos <= 27){
						array_push($resultados, array("A/R"));
						array_push($puntaje, array($puntos));
					}
				}else{
					array_push($resultados, array("S/C"));
					array_push($puntaje, array(" "));
				}
				//inefectividad y baja autoestima
				if( !is_null($inefectividad_baja_autoestima_sum[0]->puntos) ){
					$puntos = $inefectividad_baja_autoestima_sum[0]->puntos;
					if(0 <= $puntos && $puntos <= 1){
						array_push($resultados, array("B/R"));
						array_push($puntaje, array($puntos));
					}elseif(2 <= $puntos && $puntos <= 30){
						array_push($resultados, array("A/R"));
						array_push($puntaje, array($puntos));
					}
				}else{
					array_push($resultados, array("S/C"));
					array_push($puntaje, array(" "));
				}
				//perfeccionismo
				if( !is_null($perfeccionismo_sum[0]->puntos) ){
					$puntos = $perfeccionismo_sum[0]->puntos;
					array_push($resultados, array("LISTO"));
					array_push($puntaje, array($puntos));
				}else{
					array_push($resultados, array("S/C"));
					array_push($puntaje, array(" "));
				}
				//desconfianza interpersonal
				if( !is_null($desconfianza_interpersonal_sum[0]->puntos) ){
					$puntos = $desconfianza_interpersonal_sum[0]->puntos;
					array_push($resultados, array("LISTO"));
					array_push($puntaje, array($puntos));
				}else{
					array_push($resultados, array("S/C"));
					array_push($puntaje, array(" "));
				}

				//Conciencia interoceptiva
				if( !is_null($conciencia_interoceptiva_sum[0]->puntos) ){
					$puntos = $conciencia_interoceptiva_sum[0]->puntos;
					if(0 <= $puntos && $puntos <= 1){
						array_push($resultados, array("B/R"));
						array_push($puntaje, array($puntos));
					}elseif(2 <= $puntos && $puntos <= 30){
						array_push($resultados, array("A/R"));
						array_push($puntaje, array($puntos));
					}
				}else{
					array_push($resultados, array("S/C"));
					array_push($puntaje, array(" "));
				}
				//Miedo a madurar
				if( !is_null($miedo_madurar_sum[0]->puntos) ){
					$puntos = $miedo_madurar_sum[0]->puntos;
					if(0 <= $puntos && $puntos <= 1){
						array_push($resultados, array("B/R"));
						array_push($puntaje, array($puntos));
					}elseif(2 <= $puntos && $puntos <= 24){
						array_push($resultados, array("A/R"));
						array_push($puntaje, array($puntos));
					}
				}else{
					array_push($resultados, array("S/C"));
					array_push($puntaje, array(" "));
				}

				array_push($estudiantes, array($estudiante, $resultados, $puntaje));
			}

			$grupoinfo = $this->grupo->obtener_informacion( $id_grupo );

			$estudiantes_xml = array();

			$escuela_array = array("Escuela:", $grupoinfo->escuela);
			array_push($estudiantes_xml, $escuela_array);
			$grupo_array =  array("Grupo:", $grupoinfo->grupo);
			array_push($estudiantes_xml, $grupo_array);

			$arrayName = array(
			  "No lista",
			  "Nombres",
			  "Impulso a Delgadéz", "puntaje",
			  "Sintomatología Bulímica", "puntaje",
			  "Insatisfacción Corporal", "puntaje",
			  "Inafectividad Baja Autoestima", "puntaje",
			  "Perfeccionismo", "puntaje",
			  "Desconfianza Interpersonal", "puntaje",
			  "Conciencia Interoseptiva", "puntaje",
			  "Miedo a Madurar", "puntaje",
			  "Total");

			  array_push($estudiantes_xml, $arrayName);

			foreach ($estudiantes as $x => $estudiante) {
				$estudiante_xml = array();
				$sum_estudiante = 0;
				array_push($estudiante_xml, $estudiante[0]->noLista);
				array_push($estudiante_xml, $estudiante[0]->nombres);
				foreach ($estudiante[1] as $key => $respuesta) {
					array_push($estudiante_xml, $respuesta[0]);
					array_push($estudiante_xml, $estudiante[2][$key][0]);
					$sum_estudiante = $sum_estudiante + $estudiante[2][$key][0];
				}
				array_push($estudiante_xml, $sum_estudiante);
				array_push($estudiantes_xml, $estudiante_xml);
			}

			$this->load->view("excel", array("result" => $estudiantes_xml));

		}else{
			redirect(base_url());
		}

	}


	/////////////////////// ASSIST ////////////////////////////////////////
	function grupo_ASSIST(){
		$this->load->model('grupo');
		if($this->session->userdata('rol') === '0' or $this->session->userdata('rol') === '3'){
			$escala = 'ASSIST';

			$id_grupo = $this->uri->segment(3);

			$grupo = $this->db->select("Usuario.nombres, Usuario.apellidos, Usuario.usuario, Usuario.contrasena, Usuario.idUsuario, Estudiante.noLista, Estudiante.idEstudiante")
				->join('Usuario', 'Estudiante.Usuario_idUsuario = Usuario.idUsuario')
				->get_where('Estudiante', array('Estudiante.Grupo_idGrupo' => intval($id_grupo)));

			//Trastornos involucrados en la escala ASSIT
			$tabaco_id = 18;
			$alcohol_id = 19;
			$mariguana_id = 20;
			$cocaina_id = 21;
			$anfetaminas_id = 22;
			$inhalables_id = 23;
			$tranquilizantes_id = 24;
			$alucinogenos_id = 25;
			$opiaceos_id = 26;
			$otro_id = 27;

			$resultados = array();
			$estudiantes = array();

			foreach ($grupo->result() as $x => $estudiante) {
				$termino_q = $this->db->query('SELECT termino FROM  AssitTerminada WHERE idEstudiante = '.$estudiante->idEstudiante);
				$termino_q_result = $termino_q->result();

				$tabaco_query = $this->db->query("SELECT SUM(puntos) as puntos FROM Escala WHERE Estudiante_idEstudiante = \"".$estudiante->idEstudiante."\" AND Trastorno_idEscala = \"".$tabaco_id."\"");
				$alcohol_query = $this->db->query("SELECT SUM(puntos) as puntos FROM Escala WHERE Estudiante_idEstudiante = \"".$estudiante->idEstudiante."\" AND Trastorno_idEscala = \"".$alcohol_id."\"");
				$mariguana_query = $this->db->query("SELECT SUM(puntos) as puntos FROM Escala WHERE Estudiante_idEstudiante = \"".$estudiante->idEstudiante."\" AND Trastorno_idEscala = \"".$mariguana_id."\"");
				$cocaina_query = $this->db->query("SELECT SUM(puntos) as puntos FROM Escala WHERE Estudiante_idEstudiante = \"".$estudiante->idEstudiante."\" AND Trastorno_idEscala = \"".$cocaina_id."\"");
				$anfetaminas_query = $this->db->query("SELECT SUM(puntos) as puntos FROM Escala WHERE Estudiante_idEstudiante = \"".$estudiante->idEstudiante."\" AND Trastorno_idEscala = \"".$anfetaminas_id."\"");
				$inhalables_query = $this->db->query("SELECT SUM(puntos) as puntos FROM Escala WHERE Estudiante_idEstudiante = \"".$estudiante->idEstudiante."\" AND Trastorno_idEscala = \"".$inhalables_id."\"");
				$tranquilizantes_query = $this->db->query("SELECT SUM(puntos) as puntos FROM Escala WHERE Estudiante_idEstudiante = \"".$estudiante->idEstudiante."\" AND Trastorno_idEscala = \"".$tranquilizantes_id."\"");
				$alucinogenos_query = $this->db->query("SELECT SUM(puntos) as puntos FROM Escala WHERE Estudiante_idEstudiante = \"".$estudiante->idEstudiante."\" AND Trastorno_idEscala = \"".$alucinogenos_id."\"");
				$opiaceos_query = $this->db->query("SELECT SUM(puntos) as puntos FROM Escala WHERE Estudiante_idEstudiante = \"".$estudiante->idEstudiante."\" AND Trastorno_idEscala = \"".$opiaceos_id."\"");
				$otro_query = $this->db->query("SELECT SUM(puntos) as puntos FROM Escala WHERE Estudiante_idEstudiante = \"".$estudiante->idEstudiante."\" AND Trastorno_idEscala = \"".$otro_id."\"");

				$tabaco 			= $tabaco_query->result();
				$alcohol 			= $alcohol_query->result();
				$mariguana 			= $mariguana_query->result();
				$cocaina 			= $cocaina_query->result();
				$anfetaminas 		= $anfetaminas_query->result();
				$inhalables 		= $inhalables_query->result();
				$tranquilizantes 	= $tranquilizantes_query->result();
				$alucinogenos 		= $alucinogenos_query->result();
				$opiaceos 			= $opiaceos_query->result();
				$otro 				= $otro_query->result();

				$puntaje = array();

				if(
					isset($termino_q_result[0]->termino)&&
					is_null($tabaco[0]->puntos)			&&
					is_null($alcohol[0]->puntos)		&&
					is_null($mariguana[0]->puntos)		&&
					is_null($cocaina[0]->puntos)		&&
					is_null($anfetaminas[0]->puntos)	&&
					is_null($inhalables[0]->puntos)		&&
					is_null($tranquilizantes[0]->puntos)&&
					is_null($alucinogenos[0]->puntos)	&&
					is_null($opiaceos[0]->puntos)		&&
					is_null($otro[0]->puntos)
				){
					array_push($resultados, array("tabaco", "E/N"));
					array_push($resultados, array("alcohol", "E/N"));
					array_push($resultados, array("mariguana", "E/N"));
					array_push($resultados, array("cocaina", "E/N"));
					array_push($resultados, array("anfetaminas", "E/N"));
					array_push($resultados, array("inhalables", "E/N"));
					array_push($resultados, array("tranquilizantes", "E/N"));
					array_push($resultados, array("alucinogenos", "E/N"));
					array_push($resultados, array("opiaceos", "E/N"));
					array_push($resultados, array("otro", "E/N"));
				}elseif(
					is_null($tabaco[0]->puntos)			&&
					is_null($alcohol[0]->puntos)		&&
					is_null($mariguana[0]->puntos)		&&
					is_null($cocaina[0]->puntos)		&&
					is_null($anfetaminas[0]->puntos)	&&
					is_null($inhalables[0]->puntos)		&&
					is_null($tranquilizantes[0]->puntos)&&
					is_null($alucinogenos[0]->puntos)	&&
					is_null($opiaceos[0]->puntos)		&&
					is_null($otro[0]->puntos)
				){
					array_push($resultados, array("tabaco", "S/C"));
					array_push($resultados, array("alcohol", "S/C"));
					array_push($resultados, array("mariguana", "S/C"));
					array_push($resultados, array("cocaina", "S/C"));
					array_push($resultados, array("anfetaminas", "S/C"));
					array_push($resultados, array("inhalables", "S/C"));
					array_push($resultados, array("tranquilizantes", "S/C"));
					array_push($resultados, array("alucinogenos", "S/C"));
					array_push($resultados, array("opiaceos", "S/C"));
					array_push($resultados, array("otro", "S/C"));
				}else{

					if( !is_null($tabaco[0]->puntos) ){
						$puntos = $tabaco[0]->puntos;
						$puntos = $puntos+3;
						if(0 <= $puntos && $puntos <= 3){
							//Sin Intervención
							array_push($resultados, array("tabaco", "S/I"));
							array_push($puntaje, array($puntos));
						}elseif(4 <= $puntos && $puntos <= 26){
							//Intervención Breve
							array_push($resultados, array("tabaco", "I/B"));
							array_push($puntaje, array($puntos));
						}elseif(27 <= $puntos && $puntos <= 100){
							//Tratamiento Intensivo
							array_push($resultados, array("tabaco", "T/I"));
							array_push($puntaje, array($puntos));
						}
					}else{
						//Sin Contestar
						array_push($resultados, array("tabaco", "E/N"));
						array_push($puntaje, array(" "));
					}

					if( !is_null($alcohol[0]->puntos) ){
						$puntos = $alcohol[0]->puntos;
						$puntos = $puntos+3;
						if(0 <= $puntos && $puntos <= 10){
							array_push($resultados, array("alcohol", "S/I"));
							array_push($puntaje, array($puntos));
						}elseif(11 <= $puntos && $puntos <= 26){
							array_push($resultados, array("alcohol", "I/B"));
							array_push($puntaje, array($puntos));
						}elseif(27 <= $puntos && $puntos <= 100){
							array_push($resultados, array("alcohol", "T/I"));
							array_push($puntaje, array($puntos));
						}
					}else{
						array_push($resultados, array("alcohol", "E/N"));
						array_push($puntaje, array(" "));
					}

					if( !is_null($mariguana[0]->puntos) ){
						$puntos = $mariguana[0]->puntos;
						$puntos = $puntos+3;
						if(0 <= $puntos && $puntos <= 3){
							array_push($resultados, array("mariguana", "S/I"));
							array_push($puntaje, array($puntos));
						}elseif(4 <= $puntos && $puntos <= 26){
							array_push($resultados, array("mariguana", "I/B"));
							array_push($puntaje, array($puntos));
						}elseif(27 <= $puntos && $puntos <= 100){
							array_push($resultados, array("mariguana", "T/I"));
							array_push($puntaje, array($puntos));
						}
					}else{
						array_push($resultados, array("mariguana", "E/N"));
						array_push($puntaje, array(" "));
					}

					if( !is_null($cocaina[0]->puntos) ){
						$puntos = $cocaina[0]->puntos;
						$puntos = $puntos+3;
						if(0 <= $puntos && $puntos <= 3){
							array_push($resultados, array("cocaina", "S/I"));
							array_push($puntaje, array($puntos));
						}elseif(4 <= $puntos && $puntos <= 26){
							array_push($resultados, array("cocaina", "I/B"));
							array_push($puntaje, array($puntos));
						}elseif(27 <= $puntos && $puntos <= 100){
							array_push($resultados, array("cocaina", "T/I"));
							array_push($puntaje, array($puntos));
						}
					}else{
						array_push($resultados, array("cocaina", "E/N"));
						array_push($puntaje, array(" "));
					}

					if( !is_null($anfetaminas[0]->puntos) ){
						$puntos = $anfetaminas[0]->puntos;
						$puntos = $puntos+3;
						if(0 <= $puntos && $puntos <= 3){
							array_push($resultados, array("anfetaminas", "S/I"));
							array_push($puntaje, array($puntos));
						}elseif(4 <= $puntos && $puntos <= 26){
							array_push($resultados, array("anfetaminas", "I/B"));
							array_push($puntaje, array($puntos));
						}elseif(27 <= $puntos && $puntos <= 100){
							array_push($resultados, array("anfetaminas", "T/I"));
							array_push($puntaje, array($puntos));
						}
					}else{
						array_push($resultados, array("anfetaminas", "E/N"));
						array_push($puntaje, array(" "));
					}

					if( !is_null($inhalables[0]->puntos) ){
						$puntos = $inhalables[0]->puntos;
						$puntos = $puntos+3;
						if(0 <= $puntos && $puntos <= 3){
							array_push($resultados, array("inhalables", "S/I"));
							array_push($puntaje, array($puntos));
						}elseif(4 <= $puntos && $puntos <= 26){
							array_push($resultados, array("inhalables", "I/B"));
							array_push($puntaje, array($puntos));
						}elseif(27 <= $puntos && $puntos <= 100){
							array_push($resultados, array("inhalables", "T/I"));
							array_push($puntaje, array($puntos));
						}
					}else{
						array_push($resultados, array("inhalables", "E/N"));
						array_push($puntaje, array(" "));
					}

					if( !is_null($tranquilizantes[0]->puntos) ){
						$puntos = $tranquilizantes[0]->puntos;
						$puntos = $puntos+3;
						if(0 <= $puntos && $puntos <= 3){
							array_push($resultados, array("tranquilizantes", "S/I"));
							array_push($puntaje, array($puntos));
						}elseif(4 <= $puntos && $puntos <= 26){
							array_push($resultados, array("tranquilizantes", "I/B"));
							array_push($puntaje, array($puntos));
						}elseif(27 <= $puntos && $puntos <= 100){
							array_push($resultados, array("tranquilizantes", "T/I"));
							array_push($puntaje, array($puntos));
						}
					}else{
						array_push($resultados, array("tranquilizantes", "E/N"));
						array_push($puntaje, array(" "));
					}

					if( !is_null($alucinogenos[0]->puntos) ){
						$puntos = $alucinogenos[0]->puntos;
						$puntos = $puntos+3;
						if(0 <= $puntos && $puntos <= 3){
							array_push($resultados, array("alucinogenos", "S/I"));
							array_push($puntaje, array($puntos));
						}elseif(4 <= $puntos && $puntos <= 26){
							array_push($resultados, array("alucinogenos", "I/B"));
							array_push($puntaje, array($puntos));
						}elseif(27 <= $puntos && $puntos <= 100){
							array_push($resultados, array("alucinogenos", "T/I"));
							array_push($puntaje, array($puntos));
						}
					}else{
						array_push($resultados, array("alucinogenos", "E/N"));
						array_push($puntaje, array(" "));
					}

					if( !is_null($opiaceos[0]->puntos) ){
						$puntos = $opiaceos[0]->puntos;
						$puntos = $puntos+3;
						if(0 <= $puntos && $puntos <= 3){
							array_push($resultados, array("opiaceos", "S/I"));
							array_push($puntaje, array($puntos));
						}elseif(4 <= $puntos && $puntos <= 26){
							array_push($resultados, array("opiaceos", "I/B"));
							array_push($puntaje, array($puntos));
						}elseif(27 <= $puntos && $puntos <= 100){
							array_push($resultados, array("opiaceos", "T/I"));
							array_push($puntaje, array($puntos));
						}
					}else{
						array_push($resultados, array("opiaceos", "E/N"));
						array_push($puntaje, array(" "));
					}

					if( !is_null($otro[0]->puntos) ){
						$puntos = $otro[0]->puntos;
						$puntos = $puntos+3;
						if(0 <= $puntos && $puntos <= 3){
							array_push($resultados, array("otro", "S/I"));
							array_push($puntaje, array($puntos));
						}elseif(4 <= $puntos && $puntos <= 26){
							array_push($resultados, array("otro", "I/B"));
							array_push($puntaje, array($puntos));
						}elseif(27 <= $puntos && $puntos <= 100){
							array_push($resultados, array("otro", "T/I"));
							array_push($puntaje, array($puntos));
						}
					}else{
						array_push($resultados, array("otro", "E/N"));
						array_push($puntaje, array(" "));
					}
				}

				array_push($estudiantes, array($estudiante, $resultados, $puntaje));

				$resultados = array();

			}

		}else{
			redirect(base_url());
		}

		$grupo = $this->grupo->obtener_informacion( $id_grupo );

		$usr_rol=$this->session->userdata('rol');
		$active = 'assist';
		$content_type = 'content-4';
		$username = $this->session->userdata('Nombre');
		$this->load->view('admin-header', array(
												'content_type' => $content_type,
												'username'=>$username,'id_grupo'=>$id_grupo,
												'escala' => $escala,
												'grupo_info' => $grupo,
												'imprimible' => true
												));
		$this->load->view('grupo_general_todos',array('active'=>$active,'id_grupo'=>$id_grupo));
		$this->load->view("grupo_assist", array('grupo' => $estudiantes, 'escala' => $escala,'id_grupo'=>$id_grupo, 'grupo_info' => $grupo, 'usr_rol' => $usr_rol));
		$this->load->view('footer');

	}

	/////////////////////// ASSIST ////////////////////////////////////////
	function grupo_assist_xml(){
		$this->load->model('grupo');
		if($this->session->userdata('rol') === '0' or $this->session->userdata('rol') === '3'){
			$escala = 'ASSIST';

			$id_grupo = $this->uri->segment(3);

			$grupo = $this->db->select("Usuario.nombres, Usuario.apellidos, Usuario.usuario, Usuario.contrasena, Usuario.idUsuario, Estudiante.noLista, Estudiante.idEstudiante")
				->join('Usuario', 'Estudiante.Usuario_idUsuario = Usuario.idUsuario')
				->get_where('Estudiante', array('Estudiante.Grupo_idGrupo' => intval($id_grupo)));

			//Trastornos involucrados en la escala ASSIT
			$tabaco_id = 18;
			$alcohol_id = 19;
			$mariguana_id = 20;
			$cocaina_id = 21;
			$anfetaminas_id = 22;
			$inhalables_id = 23;
			$tranquilizantes_id = 24;
			$alucinogenos_id = 25;
			$opiaceos_id = 26;
			$otro_id = 27;

			$resultados = array();
			$estudiantes = array();

			foreach ($grupo->result() as $x => $estudiante) {
				$termino_q = $this->db->query('SELECT termino FROM  AssitTerminada WHERE idEstudiante = '.$estudiante->idEstudiante);
				$termino_q_result = $termino_q->result();

				$tabaco_query = $this->db->query("SELECT SUM(puntos) as puntos FROM Escala WHERE Estudiante_idEstudiante = \"".$estudiante->idEstudiante."\" AND Trastorno_idEscala = \"".$tabaco_id."\"");
				$alcohol_query = $this->db->query("SELECT SUM(puntos) as puntos FROM Escala WHERE Estudiante_idEstudiante = \"".$estudiante->idEstudiante."\" AND Trastorno_idEscala = \"".$alcohol_id."\"");
				$mariguana_query = $this->db->query("SELECT SUM(puntos) as puntos FROM Escala WHERE Estudiante_idEstudiante = \"".$estudiante->idEstudiante."\" AND Trastorno_idEscala = \"".$mariguana_id."\"");
				$cocaina_query = $this->db->query("SELECT SUM(puntos) as puntos FROM Escala WHERE Estudiante_idEstudiante = \"".$estudiante->idEstudiante."\" AND Trastorno_idEscala = \"".$cocaina_id."\"");
				$anfetaminas_query = $this->db->query("SELECT SUM(puntos) as puntos FROM Escala WHERE Estudiante_idEstudiante = \"".$estudiante->idEstudiante."\" AND Trastorno_idEscala = \"".$anfetaminas_id."\"");
				$inhalables_query = $this->db->query("SELECT SUM(puntos) as puntos FROM Escala WHERE Estudiante_idEstudiante = \"".$estudiante->idEstudiante."\" AND Trastorno_idEscala = \"".$inhalables_id."\"");
				$tranquilizantes_query = $this->db->query("SELECT SUM(puntos) as puntos FROM Escala WHERE Estudiante_idEstudiante = \"".$estudiante->idEstudiante."\" AND Trastorno_idEscala = \"".$tranquilizantes_id."\"");
				$alucinogenos_query = $this->db->query("SELECT SUM(puntos) as puntos FROM Escala WHERE Estudiante_idEstudiante = \"".$estudiante->idEstudiante."\" AND Trastorno_idEscala = \"".$alucinogenos_id."\"");
				$opiaceos_query = $this->db->query("SELECT SUM(puntos) as puntos FROM Escala WHERE Estudiante_idEstudiante = \"".$estudiante->idEstudiante."\" AND Trastorno_idEscala = \"".$opiaceos_id."\"");
				$otro_query = $this->db->query("SELECT SUM(puntos) as puntos FROM Escala WHERE Estudiante_idEstudiante = \"".$estudiante->idEstudiante."\" AND Trastorno_idEscala = \"".$otro_id."\"");

				$tabaco 			= $tabaco_query->result();
				$alcohol 			= $alcohol_query->result();
				$mariguana 			= $mariguana_query->result();
				$cocaina 			= $cocaina_query->result();
				$anfetaminas 		= $anfetaminas_query->result();
				$inhalables 		= $inhalables_query->result();
				$tranquilizantes 	= $tranquilizantes_query->result();
				$alucinogenos 		= $alucinogenos_query->result();
				$opiaceos 			= $opiaceos_query->result();
				$otro 				= $otro_query->result();

				$puntaje = array();

				if(
					isset($termino_q_result[0]->termino)&&
					is_null($tabaco[0]->puntos)			&&
					is_null($alcohol[0]->puntos)		&&
					is_null($mariguana[0]->puntos)		&&
					is_null($cocaina[0]->puntos)		&&
					is_null($anfetaminas[0]->puntos)	&&
					is_null($inhalables[0]->puntos)		&&
					is_null($tranquilizantes[0]->puntos)&&
					is_null($alucinogenos[0]->puntos)	&&
					is_null($opiaceos[0]->puntos)		&&
					is_null($otro[0]->puntos)
				){
					array_push($resultados, array("tabaco", "E/N"));
					array_push($resultados, array("alcohol", "E/N"));
					array_push($resultados, array("mariguana", "E/N"));
					array_push($resultados, array("cocaina", "E/N"));
					array_push($resultados, array("anfetaminas", "E/N"));
					array_push($resultados, array("inhalables", "E/N"));
					array_push($resultados, array("tranquilizantes", "E/N"));
					array_push($resultados, array("alucinogenos", "E/N"));
					array_push($resultados, array("opiaceos", "E/N"));
					array_push($resultados, array("otro", "E/N"));
				}elseif(
					is_null($tabaco[0]->puntos)			&&
					is_null($alcohol[0]->puntos)		&&
					is_null($mariguana[0]->puntos)		&&
					is_null($cocaina[0]->puntos)		&&
					is_null($anfetaminas[0]->puntos)	&&
					is_null($inhalables[0]->puntos)		&&
					is_null($tranquilizantes[0]->puntos)&&
					is_null($alucinogenos[0]->puntos)	&&
					is_null($opiaceos[0]->puntos)		&&
					is_null($otro[0]->puntos)
				){
					array_push($resultados, array("tabaco", "S/C"));
					array_push($resultados, array("alcohol", "S/C"));
					array_push($resultados, array("mariguana", "S/C"));
					array_push($resultados, array("cocaina", "S/C"));
					array_push($resultados, array("anfetaminas", "S/C"));
					array_push($resultados, array("inhalables", "S/C"));
					array_push($resultados, array("tranquilizantes", "S/C"));
					array_push($resultados, array("alucinogenos", "S/C"));
					array_push($resultados, array("opiaceos", "S/C"));
					array_push($resultados, array("otro", "S/C"));
				}else{

					if( !is_null($tabaco[0]->puntos) ){
						$puntos = $tabaco[0]->puntos;
						$puntos = $puntos+3;
						if(0 <= $puntos && $puntos <= 3){
							//Sin Intervención
							array_push($resultados, array("tabaco", "S/I"));
							array_push($puntaje, array($puntos));
						}elseif(4 <= $puntos && $puntos <= 26){
							//Intervención Breve
							array_push($resultados, array("tabaco", "I/B"));
							array_push($puntaje, array($puntos));
						}elseif(27 <= $puntos && $puntos <= 100){
							//Tratamiento Intensivo
							array_push($resultados, array("tabaco", "T/I"));
							array_push($puntaje, array($puntos));
						}
					}else{
						//Sin Contestar
						array_push($resultados, array("tabaco", "E/N"));
						array_push($puntaje, array(" "));
					}

					if( !is_null($alcohol[0]->puntos) ){
						$puntos = $alcohol[0]->puntos;
						$puntos = $puntos+3;
						if(0 <= $puntos && $puntos <= 10){
							array_push($resultados, array("alcohol", "S/I"));
							array_push($puntaje, array($puntos));
						}elseif(11 <= $puntos && $puntos <= 26){
							array_push($resultados, array("alcohol", "I/B"));
							array_push($puntaje, array($puntos));
						}elseif(27 <= $puntos && $puntos <= 100){
							array_push($resultados, array("alcohol", "T/I"));
							array_push($puntaje, array($puntos));
						}
					}else{
						array_push($resultados, array("alcohol", "E/N"));
						array_push($puntaje, array(" "));
					}

					if( !is_null($mariguana[0]->puntos) ){
						$puntos = $mariguana[0]->puntos;
						$puntos = $puntos+3;
						if(0 <= $puntos && $puntos <= 3){
							array_push($resultados, array("mariguana", "S/I"));
							array_push($puntaje, array($puntos));
						}elseif(4 <= $puntos && $puntos <= 26){
							array_push($resultados, array("mariguana", "I/B"));
							array_push($puntaje, array($puntos));
						}elseif(27 <= $puntos && $puntos <= 100){
							array_push($resultados, array("mariguana", "T/I"));
							array_push($puntaje, array($puntos));
						}
					}else{
						array_push($resultados, array("mariguana", "E/N"));
						array_push($puntaje, array(" "));
					}

					if( !is_null($cocaina[0]->puntos) ){
						$puntos = $cocaina[0]->puntos;
						$puntos = $puntos+3;
						if(0 <= $puntos && $puntos <= 3){
							array_push($resultados, array("cocaina", "S/I"));
							array_push($puntaje, array($puntos));
						}elseif(4 <= $puntos && $puntos <= 26){
							array_push($resultados, array("cocaina", "I/B"));
							array_push($puntaje, array($puntos));
						}elseif(27 <= $puntos && $puntos <= 100){
							array_push($resultados, array("cocaina", "T/I"));
							array_push($puntaje, array($puntos));
						}
					}else{
						array_push($resultados, array("cocaina", "E/N"));
						array_push($puntaje, array(" "));
					}

					if( !is_null($anfetaminas[0]->puntos) ){
						$puntos = $anfetaminas[0]->puntos;
						$puntos = $puntos+3;
						if(0 <= $puntos && $puntos <= 3){
							array_push($resultados, array("anfetaminas", "S/I"));
							array_push($puntaje, array($puntos));
						}elseif(4 <= $puntos && $puntos <= 26){
							array_push($resultados, array("anfetaminas", "I/B"));
							array_push($puntaje, array($puntos));
						}elseif(27 <= $puntos && $puntos <= 100){
							array_push($resultados, array("anfetaminas", "T/I"));
							array_push($puntaje, array($puntos));
						}
					}else{
						array_push($resultados, array("anfetaminas", "E/N"));
						array_push($puntaje, array(" "));
					}

					if( !is_null($inhalables[0]->puntos) ){
						$puntos = $inhalables[0]->puntos;
						$puntos = $puntos+3;
						if(0 <= $puntos && $puntos <= 3){
							array_push($resultados, array("inhalables", "S/I"));
							array_push($puntaje, array($puntos));
						}elseif(4 <= $puntos && $puntos <= 26){
							array_push($resultados, array("inhalables", "I/B"));
							array_push($puntaje, array($puntos));
						}elseif(27 <= $puntos && $puntos <= 100){
							array_push($resultados, array("inhalables", "T/I"));
							array_push($puntaje, array($puntos));
						}
					}else{
						array_push($resultados, array("inhalables", "E/N"));
						array_push($puntaje, array(" "));
					}

					if( !is_null($tranquilizantes[0]->puntos) ){
						$puntos = $tranquilizantes[0]->puntos;
						$puntos = $puntos+3;
						if(0 <= $puntos && $puntos <= 3){
							array_push($resultados, array("tranquilizantes", "S/I"));
							array_push($puntaje, array($puntos));
						}elseif(4 <= $puntos && $puntos <= 26){
							array_push($resultados, array("tranquilizantes", "I/B"));
							array_push($puntaje, array($puntos));
						}elseif(27 <= $puntos && $puntos <= 100){
							array_push($resultados, array("tranquilizantes", "T/I"));
							array_push($puntaje, array($puntos));
						}
					}else{
						array_push($resultados, array("tranquilizantes", "E/N"));
						array_push($puntaje, array(" "));
					}

					if( !is_null($alucinogenos[0]->puntos) ){
						$puntos = $alucinogenos[0]->puntos;
						$puntos = $puntos+3;
						if(0 <= $puntos && $puntos <= 3){
							array_push($resultados, array("alucinogenos", "S/I"));
							array_push($puntaje, array($puntos));
						}elseif(4 <= $puntos && $puntos <= 26){
							array_push($resultados, array("alucinogenos", "I/B"));
							array_push($puntaje, array($puntos));
						}elseif(27 <= $puntos && $puntos <= 100){
							array_push($resultados, array("alucinogenos", "T/I"));
							array_push($puntaje, array($puntos));
						}
					}else{
						array_push($resultados, array("alucinogenos", "E/N"));
						array_push($puntaje, array(" "));
					}

					if( !is_null($opiaceos[0]->puntos) ){
						$puntos = $opiaceos[0]->puntos;
						$puntos = $puntos+3;
						if(0 <= $puntos && $puntos <= 3){
							array_push($resultados, array("opiaceos", "S/I"));
							array_push($puntaje, array($puntos));
						}elseif(4 <= $puntos && $puntos <= 26){
							array_push($resultados, array("opiaceos", "I/B"));
							array_push($puntaje, array($puntos));
						}elseif(27 <= $puntos && $puntos <= 100){
							array_push($resultados, array("opiaceos", "T/I"));
							array_push($puntaje, array($puntos));
						}
					}else{
						array_push($resultados, array("opiaceos", "E/N"));
						array_push($puntaje, array(" "));
					}

					if( !is_null($otro[0]->puntos) ){
						$puntos = $otro[0]->puntos;
						$puntos = $puntos+3;
						if(0 <= $puntos && $puntos <= 3){
							array_push($resultados, array("otro", "S/I"));
							array_push($puntaje, array($puntos));
						}elseif(4 <= $puntos && $puntos <= 26){
							array_push($resultados, array("otro", "I/B"));
							array_push($puntaje, array($puntos));
						}elseif(27 <= $puntos && $puntos <= 100){
							array_push($resultados, array("otro", "T/I"));
							array_push($puntaje, array($puntos));
						}
					}else{
						array_push($resultados, array("otro", "E/N"));
						array_push($puntaje, array(" "));
					}
				}

				array_push($estudiantes, array($estudiante, $resultados, $puntaje));

				$resultados = array();

			}

			$grupoinfo = $this->grupo->obtener_informacion( $id_grupo );

			$estudiantes_xml = array();

			$escuela_array = array("Escuela:", $grupoinfo->escuela);
			array_push($estudiantes_xml, $escuela_array);
			$grupo_array =  array("Grupo:", $grupoinfo->grupo);
			array_push($estudiantes_xml, $grupo_array);

			$arrayName = array(
				"No lista",
				"Nombres",
				"tabaco", "puntaje",
				"alcohol", "puntaje",
				"mariguana", "puntaje",
				"cocaina", "puntaje",
				"anfetaminas", "puntaje",
				"inhalables", "puntaje",
				"tranquilizantes", "puntaje",
				"alucinogenos", "puntaje",
				"opiaceos", "puntaje",
				"otro", "puntaje"
			);

			array_push($estudiantes_xml, $arrayName);

			foreach ($estudiantes as $x => $estudiante) {
				$estudiante_xml = array();
				array_push($estudiante_xml, $estudiante[0]->noLista);
				array_push($estudiante_xml, $estudiante[0]->nombres);
				foreach ($estudiante[1] as $key => $respuesta) {
					array_push($estudiante_xml, $respuesta[1]);
					if( !empty( $estudiante[2] ) ){
						array_push($estudiante_xml, $estudiante[2][$key][0]);
					}else{
						array_push($estudiante_xml, "");
					}
				}
				array_push($estudiantes_xml, $estudiante_xml);
			}

			$this->load->view("excel", array("result" => $estudiantes_xml));
		}else{
			redirect(base_url());
		}

	}

	public function usuarios(){
		if($this->session->userdata('rol') === '0'){
			$usuarios = $this->db->get_where("Usuario", array('rol' => 0));

		}else{
			redirect(base_url());
		}

	}

	public function registro(){
		if($this->session->userdata('rol') === '0'){
			$username = $this->session->userdata('Nombre');
			$this->load->library("form_validation");
			$this->load->view('admin-header',array('username'=> $username));
			$this->load->view('registro_usuario');
			$this->load->view("footer");
		}else{
			redirect(base_url());
		}
	}

	public function registro_usuario(){
		if($this->session->userdata('rol') === '0'){

			$this->load->library("form_validation");

			$this->form_validation->set_rules('nombres', 'Nombres', 'required');
			$this->form_validation->set_rules('apellidos', 'Apellidos', 'required');
			$this->form_validation->set_rules('correo', 'Correo', 'required');
			$this->form_validation->set_rules('usuario', 'Usuario', 'required');
			$this->form_validation->set_rules('password', 'Password', 'required');
			$this->form_validation->set_rules('repassword', 'Repetir Password', 'required');

			if ($this->form_validation->run() == FALSE){

				$this->load->view('registro_usuario');

			}else{

				$this->load->model('UsuarioModel');
				$this->load->helper("security");

				$id = $this->UsuarioModel->agrega_usuario(
					$this->input->post("nombres"),
					$this->input->post("apellidos"),
					$this->input->post("correo"),
					$this->input->post("password"),
					$this->input->post("rol"),
					$this->input->post("telefono"),
					$this->input->post("edad"),
					$this->input->post("sexo"),
					0,
					$this->input->post("usuario")
				);

				$this->session->set_flashdata( 'user_id', $id );

				redirect( base_url()."index.php/admin/administradores" );
			}
		}else{
			redirect(base_url());
		}
	}
	public function grupo_escalas_todos(){
		$this->load->library('session');

		if($this->session->userdata('rol') === '0'){
			$username = $this->session->userdata('Nombre');
			$this->load->view('admin-header',array('username'=>$username));
			$this->load->view('grupo_general_todos');
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}

	public function escuelas(){
		$this->load->model("escuela");

		if($this->session->userdata('rol') === '0'){

			$escuelas = $this->escuela->obtener_escuelas();

			$username = $this->session->userdata('Nombre');
			$this->load->view('admin-header',array('username'=>$username));
			$this->load->view("escuelas", array("escuelas" => $escuelas->result()));
			$this->load->view('footer');

		}else{
			redirect(base_url());

		}
	}
	public function borrar_escuela(){
		$this->load->model("escuela");
		if($this->session->userdata('rol') === '0'){
			$id = $this->uri->segment(3);

			$this->escuela->eliminar_escuela($id);

			redirect(site_url("admin/grupo_crud"));
		}else{
			redirect(base_url());
		}
	}
	public function borrar_grupo(){
		$this->load->model("grupo");
		if($this->session->userdata('rol') === '0'){
			$id = $this->uri->segment(3);

			$this->grupo->eliminar_grupo($id);

			redirect(site_url("admin/grupo_crud"));
		}else{
			redirect(base_url());
		}
	}
	public function administradores(){
		if($this->session->userdata('rol') === '0'){

			$admins = $this->db->where("rol", 3)->or_where("rol", 0)->get("Usuario");

			$username = $this->session->userdata('Nombre');
			$this->load->view('admin-header',array('username'=>$username));
			$this->load->view("admins", array("admins" => $admins->result()));
			$this->load->view('footer');

		}else{
			redirect(base_url());
		}

	}

	public function borrar_usuario(){
		if($this->session->userdata('rol') === '0'){

			$id = $this->uri->segment(3);

			$usr_kind_q = $this->db->query("SELECT `rol` FROM `Usuario` WHERE `idUsuario` = '".$id."'");
			$usr_group_q = $this->db->query("SELECT `Grupo_idGrupo` FROM `Estudiante` WHERE `Usuario_idUsuario` = '".$id."'");

			$this->db->query("SET FOREIGN_KEY_CHECKS = 0");
			$this->db->where( 'idUsuario', $id )->delete( 'Usuario' );
			$this->db->query("DELETE FROM `AssitTerminada` WHERE `idEstudiante` = '".$id."'");
			if ($usr_kind_q->num_rows() > 0){
			   foreach ($usr_kind_q->result() as $row){
			      $usr_kind = $row->rol;
			   }
			}
			if ($usr_group_q->num_rows() > 0){
			   foreach ($usr_group_q->result() as $row){
			      $usr_group = $row->Grupo_idGrupo;
			   }
			}

			if($usr_kind==='0' || $usr_kind === '3'){
				redirect(site_url("admin/administradores"));
			}elseif($usr_kind==='1'){
				redirect(site_url("admin/grupo/".$usr_group));
			}

		}else{
			redirect(base_url());
		}

	}

	function grupo_cuestionarios(){
		if($this->session->userdata('rol') === '0' or $this->session->userdata('rol') === '3'){
			$id_grupo = $this->uri->segment(3);
			$active="cuestionarios";

			$grupo = $this->db->select("Usuario.idUsuario, Usuario.nombres, Usuario.apellidos, Usuario.usuario, Usuario.contrasena,Usuario.edad, Usuario.sexo, Estudiante.noLista")
			->join('Usuario', 'Estudiante.Usuario_idUsuario = Usuario.idUsuario')
			->get_where('Estudiante', array('Estudiante.Grupo_idGrupo' => intval($id_grupo)));
			$content_type = 'content-4';
			$username = $this->session->userdata('Nombre');
			$this->load->view('admin-header', array('content_type' => $content_type,'username'=>$username));
			$this->load->view('grupo_general_todos', array('active'=>$active,'id_grupo'=>$id_grupo));
			$this->load->view("grupo", array('grupo' => $grupo->result(),'id_grupo'=>$id_grupo));
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	function cuestionarios(){
		$this->load->model('grupo');
		$id_grupo = $this->uri->segment(3);
		$active="cuestionarios";

		$grupo = $this->db->select("Usuario.nombres, Usuario.apellidos, Usuario.usuario, Usuario.contrasena, Usuario.idUsuario, Estudiante.nolista, Estudiante.idEstudiante")
		->join('Usuario', 'Estudiante.Usuario_idUsuario = Usuario.idUsuario')
		->get_where('Estudiante', array('Estudiante.Grupo_idGrupo' => intval($id_grupo)));

		$lista = array();

		$el_grupo = $grupo->result();

		foreach ( $el_grupo as $estudiante ) {

			$cuestionarios = $this->db->select('CuestionarioContestado.contestado, CuestionarioContestado.Escala')
			->get_where('CuestionarioContestado', array('idEstudiante' => $estudiante->idEstudiante));

			$el_cuestionario = $cuestionarios->result();

			$c_snap = false;
			$c_edi = false;
			$c_assist = false;
			$c_beck1 = false;
			$c_beck2 = false;

			foreach ( $el_cuestionario as $cuestionario ) {

				if( !empty( $cuestionario ) ){
					if( $cuestionario->Escala == "snap" ){
						$c_snap = true;
					}elseif( $cuestionario->Escala == "edi" ){
						$c_edi = true;
					}elseif( $cuestionario->Escala == "assist" ){
						$c_assist = true;
					}elseif( $cuestionario->Escala == "beck1" ){
						$c_beck1 = true;
					}elseif( $cuestionario->Escala == "beck2" ){
						$c_beck2 = true;
					}
				}
			}
			$estudiante_array  = array(
										"estudiante" => $estudiante,
										"snap" => $c_snap,
										"beck1" => $c_beck1,
										"beck2" => $c_beck2,
										"edi" => $c_edi,
										"assist" => $c_assist
										);

			array_push($lista, $estudiante_array);

		}

		$grupo = $this->grupo->obtener_informacion( $id_grupo );
		$escala = "cuestionarios";
		$content_type = 'content-4';
		$username = $this->session->userdata('Nombre');
		$this->load->view('admin-header', array(
												'content_type' => $content_type,
												'username'=>$username,
												'id_grupo'=>$id_grupo,
												'escala' => $escala,
												'grupo_info' => $grupo,
												'imprimible' => true
												));
		$this->load->view('grupo_general_todos', array('active' => $active, 'id_grupo' => $id_grupo));
		$this->load->view("grupo_cuestionarios", array('lista' => $lista, 'id_grupo' => $id_grupo));
		$this->load->view('footer');
	}

	function agrega_estudiante(){
		$this->load->helper("usuario");

		if($this->session->userdata('rol') === '0' or $this->session->userdata('rol') === '3'){
			//Sustituir por la forma de hacer las contraseñas
			$pass = randomString(7);

			$usuario =  usuario($this->input->post("escuela"),$this->input->post("grupo_nombre"),$this->input->post("nolista"));

						//Se crea el usuario
			$this->db->insert('Usuario', array(
				'nombres' => $this->input->post("nombres"),
				'apellidos' => '',
				'contrasena' => $pass,
				'usuario' => $usuario,
				'rol' => 1
			));

			$id_usuario = $this->db->insert_id();
			//Se crea el estudiante

			$this->db->insert('Estudiante', array(
				'Usuario_idUsuario' => $id_usuario,
				'Grupo_idGrupo' => $this->input->post("grupo"),
				'noLista' => $this->input->post("nolista"),
				'turno' => '',
				'grado' => ''
			));


			redirect(site_url("admin/grupo/".$this->input->post("grupo")));
		}else{
			redirect(base_url());
		}
	}

	function resetea_escala(){

		if($this->session->userdata('rol') === '0' or $this->session->userdata('rol') === '3'){
			$id_estudiante = $this->uri->segment(3);
			$escala = $this->uri->segment(4);
			$grupo = $this->uri->segment(5);

			$this->db->delete('Escala', array('Estudiante_idEstudiante' => $id_estudiante, 'Trastorno_idEscala' => $escala));

			redirect( site_url( "admin/grupo/".$grupo ) );
		}else{
			redirect(base_url());
		}
	}

	function escala_beck2(){
		if($this->session->userdata('rol') === '0' or $this->session->userdata('rol') === '3'){

			$username = $this->session->userdata('Nombre');

			$id_alumno = $this->uri->segment(3);

			// $query = $this->db->get_where("Escala", array(
			// 	"Estudiante_idEstudiante" => $id_alumno,
			// 	"Trastorno_idEscala" => 9
			// ));
			$my_query = 'SELECT `pregunta`,`Estudiante_idEstudiante`,`puntos`,`Trastorno_idEscala` FROM `Escala`,`Estudiante` WHERE Estudiante.Usuario_idUsuario = "'.$id_alumno.'" AND Estudiante.idEstudiante =  Escala.Estudiante_idEstudiante AND Escala.Trastorno_idEscala = "9"';
			$query = $this->db->query($my_query);

			$name_query_s = 'SELECT nombres FROM Usuario WHERE idUsuario = "'.$id_alumno.'"';
			$name_query = $this->db->query($name_query_s);

			$this->load->view('admin-header', array('username'=>$username));
			$this->load->view("admin-escalas/beck2", array("respuestas"=> $query->result(), "id_alumno" => $id_alumno,"nombre_alumno" =>$name_query->result()));
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}

	}

	function escala_beck1(){
		if($this->session->userdata('rol') === '0' or $this->session->userdata('rol') === '3'){

			$username = $this->session->userdata('Nombre');

			$id_alumno = $this->uri->segment(3);

			// $query = $this->db->get_where("Escala", array(
			// 	"Estudiante_idEstudiante" => $id_alumno,
			// 	"Trastorno_idEscala" => 7
			// ));
			$my_query = 'SELECT `pregunta`,`Estudiante_idEstudiante`,`puntos`,`Trastorno_idEscala` FROM `Escala`,`Estudiante` WHERE Estudiante.Usuario_idUsuario = "'.$id_alumno.'" AND Estudiante.idEstudiante =  Escala.Estudiante_idEstudiante AND Escala.Trastorno_idEscala = "7"';
			$query = $this->db->query($my_query);

			$name_query_s = 'SELECT nombres FROM Usuario WHERE idUsuario = "'.$id_alumno.'"';
			$name_query = $this->db->query($name_query_s);

			$this->load->view('admin-header', array('username'=>$username));
			$this->load->view("admin-escalas/beck1", array("respuestas"=> $query->result(), "id_alumno" => $id_alumno,"nombre_alumno" =>$name_query->result()));
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}


	function escala_snap(){
		if($this->session->userdata('rol') === '0' or $this->session->userdata('rol') === '3'){

			$username = $this->session->userdata('Nombre');

			$id_alumno = $this->uri->segment(3);

			// $query = $this->db->get_where("Escala", array(
			// 	"Estudiante_idEstudiante" => $id_alumno,
			// 	"Trastorno_idEscala" => 8
			// ));
			$my_query = 'SELECT `pregunta`,`Estudiante_idEstudiante`,`puntos`,`Trastorno_idEscala` FROM `Escala`,`Estudiante` WHERE Estudiante.Usuario_idUsuario = "'.$id_alumno.'" AND Estudiante.idEstudiante =  Escala.Estudiante_idEstudiante AND Escala.Trastorno_idEscala = "8"';
			$query = $this->db->query($my_query);

			$name_query_s = 'SELECT nombres FROM Usuario WHERE idUsuario = "'.$id_alumno.'"';
			$name_query = $this->db->query($name_query_s);

			$this->load->view('admin-header', array('username'=>$username));
			$this->load->view("admin-escalas/tdah-secu", array("respuestas"=> $query->result(),"id_alumno" => $id_alumno,"nombre_alumno" =>$name_query->result()));
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}
	function escala_assist(){
		if($this->session->userdata('rol') === '0' or $this->session->userdata('rol') === '3'){

			$username = $this->session->userdata('Nombre');

			$id_alumno = $this->uri->segment(3);
			$my_query_string = 'SELECT `idEstudiante` FROM `Estudiante` WHERE Usuario_idUsuario = "'.$id_alumno.'"';
			$query = $this->db->query($my_query_string);
			$estudiante = $query->result();
			$estudiante_id = $estudiante[0]->idEstudiante;
			$name_query_s = 'SELECT nombres FROM Usuario WHERE idUsuario = "'.$id_alumno.'"';
			$name_query = $this->db->query($name_query_s);


			$tabaco_id = 18;
			$alcohol_id = 19;
			$mariguana_id = 20;
			$cocaina_id = 21;
			$anfetaminas_id = 22;
			$inhalables_id = 23;
			$tranquilizantes_id = 24;
			$alucinogenos_id = 25;
			$opiaceos_id = 26;
			$otro_id = 27;

			$where_tabaco = "Estudiante_idEstudiante = ".$estudiante_id." AND Trastorno_idEscala=".$tabaco_id;
			$where_alcohol = "Estudiante_idEstudiante = ".$estudiante_id." AND Trastorno_idEscala=".$alcohol_id;
			$where_mariguana = "Estudiante_idEstudiante = ".$estudiante_id." AND Trastorno_idEscala=".$mariguana_id;
			$where_cocaina = "Estudiante_idEstudiante = ".$estudiante_id." AND Trastorno_idEscala=".$cocaina_id;
			$where_anfetaminas = "Estudiante_idEstudiante = ".$estudiante_id." AND Trastorno_idEscala=".$anfetaminas_id;
			$where_inhalables = "Estudiante_idEstudiante = ".$estudiante_id." AND Trastorno_idEscala=".$inhalables_id;
			$where_tranquilizantes = "Estudiante_idEstudiante = ".$estudiante_id." AND Trastorno_idEscala=".$tranquilizantes_id;
			$where_alucinogenos = "Estudiante_idEstudiante = ".$estudiante_id." AND Trastorno_idEscala=".$alucinogenos_id;
			$where_opiaceos = "Estudiante_idEstudiante = ".$estudiante_id." AND Trastorno_idEscala=".$opiaceos_id;
			$where_otro = "Estudiante_idEstudiante = ".$estudiante_id." AND Trastorno_idEscala=".$otro_id;

			#$where = "Estudiante_idEstudiante = ".$estudiante_id." AND Trastorno_idEscala=".$tabaco_id." OR Trastorno_idEscala=".$alcohol_id." OR Trastorno_idEscala=".$mariguana_id." OR Trastorno_idEscala=".$cocaina_id." OR Trastorno_idEscala=".$anfetaminas_id." OR Trastorno_idEscala=".$inhalables_id." OR Trastorno_idEscala=".$tranquilizantes_id." OR Trastorno_idEscala=".$alucinogenos_id." OR Trastorno_idEscala=".$opiaceos_id." OR Trastorno_idEscala=".$otro_id;

			$query_tabaco = $this->db->select("*")->from("Escala")->where($where_tabaco)->get();
			$query_alcohol = $this->db->select("*")->from("Escala")->where($where_alcohol)->get();
			$query_mariguana = $this->db->select("*")->from("Escala")->where($where_mariguana)->get();
			$query_cocaina = $this->db->select("*")->from("Escala")->where($where_cocaina)->get();
			$query_anfetaminas = $this->db->select("*")->from("Escala")->where($where_anfetaminas)->get();
			$query_inhalables = $this->db->select("*")->from("Escala")->where($where_inhalables)->get();
			$query_tranquilizantes = $this->db->select("*")->from("Escala")->where($where_tranquilizantes)->get();
			$query_alucinogenos = $this->db->select("*")->from("Escala")->where($where_alucinogenos)->get();
			$query_opiaceos = $this->db->select("*")->from("Escala")->where($where_opiaceos)->get();
			$query_otro = $this->db->select("*")->from("Escala")->where($where_otro)->get();

			$resultado = array(
				"tabaco" => $query_tabaco->result(),
				"alcohol" => $query_alcohol->result(),
				"mariguana" => $query_mariguana->result(),
				"cocaina" => $query_cocaina->result(),
				"anfetaminas" => $query_anfetaminas->result(),
				"inhalables" => $query_inhalables->result(),
				"tranquilizantes" => $query_tranquilizantes->result(),
				"alucinogenos" => $query_alucinogenos->result(),
				"opiaceos" => $query_opiaceos->result(),
				"otro" => $query_otro->result()
			);

			// echo "<pre>";
			// var_dump($resultado);
			// echo "</pre>";

			$this->load->view('admin-header', array('username'=>$username));
			$this->load->view("admin-escalas/assist", array("respuestas"=> $resultado, "id_alumno" => $id_alumno,"nombre_alumno" =>$name_query->result()));
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}

	function escala_edi(){
		if($this->session->userdata('rol') === '0' or $this->session->userdata('rol') === '3'){
			$username = $this->session->userdata('Nombre');

			$id_alumno = $this->uri->segment(3);
			$my_query_string = 'SELECT `idEstudiante` FROM `Estudiante` WHERE Usuario_idUsuario = "'.$id_alumno.'"';
			$query = $this->db->query($my_query_string);
			$estudiante = $query->result();
			$estudiante_id = $estudiante[0]->idEstudiante;
			$name_query_s = 'SELECT nombres FROM Usuario WHERE idUsuario = "'.$id_alumno.'"';
			$name_query = $this->db->query($name_query_s);

			$impulso_delgadez = 10;
			$sintomatologia_bulimica = 11;
			$instisfaccion_corporal = 12;
			$inefectividad_baja_autoestima = 13;
			$perfeccionismo = 14;
			$desconfianza_interpersonal = 15;
			$conciencia_interoceptiva = 16;
			$miedo_madurar = 17;

			$where_impulso_delgadez = "Estudiante_idEstudiante = ".$estudiante_id." AND Trastorno_idEscala=".$impulso_delgadez;
			$where_sintomatologia_bulimica = "Estudiante_idEstudiante = ".$estudiante_id." AND Trastorno_idEscala=".$sintomatologia_bulimica;
			$where_instisfaccion_corporal = "Estudiante_idEstudiante = ".$estudiante_id." AND Trastorno_idEscala=".$instisfaccion_corporal;
			$where_inefectividad_baja_autoestima = "Estudiante_idEstudiante = ".$estudiante_id." AND Trastorno_idEscala=".$inefectividad_baja_autoestima;
			$where_perfeccionismo = "Estudiante_idEstudiante = ".$estudiante_id." AND Trastorno_idEscala=".$perfeccionismo;
			$where_desconfianza_interpersonal = "Estudiante_idEstudiante = ".$estudiante_id." AND Trastorno_idEscala=".$desconfianza_interpersonal;
			$where_conciencia_interoceptiva = "Estudiante_idEstudiante = ".$estudiante_id." AND Trastorno_idEscala=".$conciencia_interoceptiva;
			$where_miedo_madurar = "Estudiante_idEstudiante = ".$estudiante_id." AND Trastorno_idEscala=".$miedo_madurar;

			$query_impulso_delgadez = $this->db->select("*")->from("Escala")->where($where_impulso_delgadez)->get();
			$query_sintomatologia_bulimica = $this->db->select("*")->from("Escala")->where($where_sintomatologia_bulimica)->get();
			$query_instisfaccion_corporal = $this->db->select("*")->from("Escala")->where($where_instisfaccion_corporal)->get();
			$query_inefectividad_baja_autoestima = $this->db->select("*")->from("Escala")->where($where_inefectividad_baja_autoestima)->get();
			$query_perfeccionismo = $this->db->select("*")->from("Escala")->where($where_perfeccionismo)->get();
			$query_desconfianza_interpersonal = $this->db->select("*")->from("Escala")->where($where_desconfianza_interpersonal)->get();
			$query_conciencia_interoceptiva = $this->db->select("*")->from("Escala")->where($where_conciencia_interoceptiva)->get();
			$query_miedo_madurar = $this->db->select("*")->from("Escala")->where($where_miedo_madurar)->get();


			$resultado = array(
				"impulso_delgadez" => $query_impulso_delgadez->result(),
				"sintomatologia_bulimica" => $query_sintomatologia_bulimica->result(),
				"instisfaccion_corporal" => $query_instisfaccion_corporal->result(),
				"inefectividad_baja_autoestima" => $query_inefectividad_baja_autoestima->result(),
				"perfeccionismo" => $query_perfeccionismo->result(),
				"desconfianza_interpersonal" => $query_desconfianza_interpersonal->result(),
				"conciencia_interoceptiva" => $query_conciencia_interoceptiva->result(),
				"miedo_madurar" => $query_miedo_madurar->result()
			);
			// echo "<pre>";
			// var_dump($resultado);
			// echo "</pre>";

			$this->load->view('admin-header', array('username'=>$username));
			$this->load->view("admin-escalas/edi", array("respuestas"=> $resultado, "id_alumno" => $id_alumno,"nombre_alumno" =>$name_query->result()));
			$this->load->view('footer');

		}else{
			redirect(base_url());
		}
	}

	function grupo_crud(){
		if($this->session->userdata('rol') === '0' or $this->session->userdata('rol') === '3'){
			$this->load->model("escuela");
			$this->load->model("grupo");

			$escuelas_query = $this->escuela->obtener_escuelas();
			$escuelas = $escuelas_query->result();
			$escuelas_array = array();

			foreach ($escuelas as $escuela) {
				$escuela_array = (array)$escuela;
				$grupos_query = $this->grupo->obtener_grupos_por_escuela( $escuela->idEscuela );
				$grupos = $grupos_query->result();
				$escuela_array["grupos"] = $grupos;
				$escuela = (object)$escuela_array;

				array_push($escuelas_array, $escuela);
			}
			$content_type = 'content-3';
			$username = $this->session->userdata('Nombre');
			// echo "<pre>";
			// var_dump($escuelas_array);
			// echo "</pre>";
			$this->load->view('admin-header', array('content_type' => $content_type,'username'=>$username));
			$this->load->view('escuelas_general', array('escuelas'=>$escuelas_array));
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}

	function resetear_escala(){
		if($this->session->userdata('rol') === '0' or $this->session->userdata('rol') === '3'){
			$fallo = $this->uri->segment(3);
			$content_type = 'content-3';
			$username = $this->session->userdata('Nombre');
			$this->load->view('admin-header', array('content_type' => $content_type,'username'=>$username));
			$this->load->view('reset_escala', array('fallo' => $fallo));
			$this->load->view('footer');
		}else{
			redirect(base_url());
		}
	}



	function resetea_alumno(){
		if($this->session->userdata('rol') === '0' or $this->session->userdata('rol') === '3'){
			$this->load->model('estudiante');
			$this->load->model('grupo');
			
			$active="cuestionarios";

			$idEstudiante = $this->input->post("idEstudiante");
			$idEscala = $this->input->post("escala");

			if ($idEstudiante != "") :

				$grupo = $this->db->select("Estudiante.Grupo_idGrupo")
				->get_where('Estudiante', array('Estudiante.idEstudiante' => $idEstudiante));

				$el_grupo = $grupo->result()[0]->Grupo_idGrupo;

				// echo $idEstudiante."<br>";
				// echo $idEscala."<br>";
				// echo $el_grupo;

				$this->estudiante->resetea_escala( $idEstudiante, $idEscala );

				switch ($idEscala) {
					case '0': // SNAP – TDAH
						redirect( site_url( "admin/grupo_escalas/".$el_grupo ) );
					break;
					case '1': // BECK1
						redirect( site_url( "admin/grupo_escalas/".$el_grupo ) );
					break;
					case '2': // BECK2
						redirect( site_url( "admin/grupo_escalas/".$el_grupo ) );
					break;
					case '3': // EDI
						redirect( site_url( "admin/grupo_edi/".$el_grupo ) );
					break;
					case '4': // ASSIST
						redirect( site_url( "admin/grupo_assist/".$el_grupo ) );
					break;
					case '100': // ASSIST
						redirect( site_url( "admin/resetear_escala/true" ) );
					break;
					
					default:
						redirect( site_url( "admin/resetear_escala/" ) );
					break;
				}
			else:
				redirect( site_url( "admin/resetear_escala/true" ) );
			endif;
		}else{
			redirect(base_url());
		}	
	}
}
